doc <:doc< 
   @begin[doc]
   This is a CS101 customization of the @tt[Itt_list2] module.
   @end[doc]
>>

doc <:doc< @doc{@parents} >>
extends Itt_list
extends Itt_logic
extends Itt_struct2
doc docoff

open Dtactic
open Typeinf
open Top_conversionals

(************************************************************************
 * SYNTAX                                                               *
 ************************************************************************)

doc <:doc< 
   @begin[doc]
   @noindent
   The @tt{append} term takes two lists and concatenates them.
   @end[doc]
>>
define unfold_append :
   append{'l1; 'l2} <--> list_ind{'l1;'l2;h,t,a.('h::'a) } 

doc <:doc< 
   @begin[doc]
   @noindent
   The @tt[rev] function returns a list with the same elements as
   list $l$, but in reverse order.
   @end[doc]
>>
define unfold_rev : rev{'l} <--> (*???*) 'l (*???*)

doc docoff

(************************************************************************
 * REWRITES                                                             *
 ************************************************************************)

doc <:doc< 
   @begin[doc]
   @rewrites
   @end[doc]
>>

interactive_rw append_nil {| reduce |} :
   append{nil;'l} <--> 'l

interactive_rw append_cons {| reduce |} :
   append{('h::'t);'l} <--> ('h::append{'t;'l})

interactive_rw append_assoc 'A:
   ('l1 in list{'A}) -->
   append{append{'l1;'l2};'l3} <-->
   append{'l1;append{'l2;'l3}}

interactive_rw append_to_nil 'A:
   ('l in list{'A}) -->
   append{'l;nil} <--> 'l

doc docoff

(************************************************************************
 * DISPLAY                                                              *
 ************************************************************************)

prec prec_append

dform append_df : except_mode[src] :: parens :: "prec"[prec_append] :: append{'l1; 'l2} =
   slot["le"]{'l1} `" @" space slot{'l2}

dform rev_df : except_mode[src] :: rev{'l} =
   `"rev(" slot{'l} `")"


(*
 * -*-
 * Local Variables:
 * Caml-master: "nl"
 * End:
 * -*-
 *)
