(* CS 101 HW8 *)

extends Itt_logic
extends Itt_int_base
extends Itt_quotient

open Tactic_type
open Tactic_type.Tacticals
open Tactic_type.Sequent
open Tactic_type.Conversionals
open Mptop
open Var

open Dtactic
open Auto_tactic
open Top_conversionals
open Itt_equal
open Itt_int_base

(* Part I *)

define unfold_pairs: pairs{'T} <--> quot x, y : ('T * 'T) // (('x = 'y in 'T*'T) or (fst{'x} = snd{'y} in 'T & snd{'x} = fst{'y} in 'T))

define unfold_sum: sum{'p} <--> (fst{'p} +@ snd{'p})

let fold_pairs = makeFoldC << pairs{'T} >> unfold_pairs

interactive pairEqualElim {| elim[] |} 'H :
   sequent { <H>; x: ('a,'b)=('c,'d) in 'T1*'T2; <J['x]>; y: 'a='c in 'T1; z: 'b='d in 'T2 >- 'C['x] } -->
   sequent { <H>; x: ('a,'b)=('c,'d) in 'T1*'T2; <J['x]> >- 'C['x] }

interactive pairs_type {| intro[] |} :
   sequent { <H> >- 'T Type } -->
   sequent { <H> >- pairs{'T} Type }

interactive pairs_univ {| intro[] |} :
   sequent { <H> >- 'T in univ[i:l] } -->
   sequent { <H> >- pairs{'T} in univ[i:l] }

interactive sum_int {| intro[] |} :
   sequent { <H> >- 'p in pairs{int} } -->
   sequent { <H> >- sum{'p} in int }

interactive pairs_test1 {| intro[] |} :
   sequent { <H> >- (1,1) in pairs{int} }

interactive pairs_test2 {| intro[] |} :
   sequent { <H> >- (1,2) = (2,1) in pairs{int} }

interactive_rw sum_test :
   sum{(1,2)} <--> 3

(* Part II *)

define unfold_Col:
   Col[i:l]{'T} <--> (quot c1,c2 : ('T -> univ[i:l]) // (all t:'T. iff{squash{.'c1 't};squash{.'c2 't}}))

define unfold_mem:
   mem{'t;'c} <--> esquash{.'c 't}

define unfold_col_sub: col_sub{'c1;'c2} <--> lambda{t.(mem{'t; 'c1} & "not"{mem{'t; 'c2}})}

interactive col_type {| intro [] |} :
   sequent{ <H> >- 'T Type} -->
   sequent{ <H> >- Col[i:l]{'T} Type}

interactive col_univ {| intro [] |} :
   sequent{ <H> >- 'T in univ[i:l] } -->
   sequent{ <H> >- Col[i:l]{'T} in univ[i':l] }

interactive mem_univ {| intro [intro_typeinf <<'t>>] |} 'T :
   sequent{ <H> >- 't in 'T } -->
   sequent{ <H> >- 'c in Col[i:l]{'T} } -->
   sequent{ <H> >- mem{'t;'c} in univ[i:l] }

interactive mem_type {| intro [intro_typeinf <<'c>>] |} Col[i:l]{'T} :
   sequent{ <H> >- 't in 'T } -->
   sequent{ <H> >- 'c in Col[i:l]{'T} } -->
   sequent{ <H> >- mem{'t;'c} Type }

interactive col_sub_type {| intro[] |} :
   sequent{ <H> >- 'T Type} -->
   sequent{ <H> >- 'c1 in Col[i:l]{'T} } -->
   sequent{ <H> >- 'c2 in Col[i:l]{'T} } -->
   sequent{ <H> >- col_sub{'c1; 'c2} in Col[i:l]{'T} }

interactive partII_3_1 :
   sequent{ <H> >- mem{'t; 'c1} } -->
   sequent{ <H> >- "not"{mem{'t; 'c2}} } -->
   sequent{ <H> >- mem{'t; col_sub{'c1; 'c2}} }

interactive partII_3_2 'c2 Col[i:l]{'T} :
   sequent{ <H> >- 't in 'T } -->
   sequent{ <H> >- 'c1 in Col[i:l]{'T} } -->
   sequent{ <H> >- 'c2 in Col[i:l]{'T} } -->
   sequent{ <H> >- mem{'t; col_sub{'c1; 'c2}} } -->
   sequent{ <H> >- mem{'t; 'c1} }

interactive partII_3_3 'c1 Col[i:l]{'T} :
   sequent{ <H> >- 't in 'T } -->
   sequent{ <H> >- 'c1 in Col[i:l]{'T} } -->
   sequent{ <H> >- 'c2 in Col[i:l]{'T} } -->
   sequent{ <H> >- mem{'t; col_sub{'c1; 'c2}} } -->
   sequent{ <H> >- "not"{mem{'t; 'c2}} }

(******************************************
 * DISPLAY                                *
 ******************************************)

dform pairs : pairs{'T} = `"Pairs(" 'T `")"
dform sum: sum{'p} = `"sum(" 'p `")"
dform col: Col[i:l]{'T} = `"Col[" slot[i:l] `"](" 'T `")"
dform mem: parens :: "prec"[prec_equal] :: mem{'t;'c} =
   szone slot{'t} `" " Nuprl_font!"member" subc hspace slot{'c} ezone
dform col_sub : parens :: "prec"[prec_add] :: col_sub{'c1;'c2} =
   szone slot{'c1} `" -" subc hspace slot{'c2} ezone
