#!/bin/sh
cd `dirname $0`
cd ../..
DIR=`pwd`
TEMP=`mktemp -d /tmp/cs101.XXXXXX`
make opt || exit 1
cat << END_OF_CAT | editor/ml/mpopt || exit 1
set_tex_file "$TEMP/theory.tex";;
print_theory "cs101_lc";;
print_theory "cs101_int";;
print_theory "cs101_cla";;
END_OF_CAT
pwd
cd $TEMP
if [ "$TEXINPUTS" ]; then
   export TEXINPUTS="$TEXINPUTS:$DIR/doc/latex/inputs"
else
   export TEXINPUTS=":.:$DIR/doc/latex/inputs"
fi
latex theory || exit 1
latex theory || exit 1
cd $DIR/theories/cs101
mv -f $TEMP/theory.dvi . || exit 1
echo " "
echo "======================================================================="
echo "|| The listing of the theory is located in `dirname $0`/theory.dvi ||"
echo "======================================================================="
rm -rf $TEMP

