doc <:doc< 
   @begin[doc]
   @module{CS101 $@lambda$-calculus theory}
   @parents
   @end[doc]
>>

extends Base_theory

open Tactic_type.Tacticals
open Top_conversionals
open Dtactic
open Auto_tactic

doc <:doc<
   @begin[doc]
   @modsection{Basic $@lambda$-calculus computational rules}
   @end[doc]
>>

declare lambda{x.'t}
declare apply{'a; 'b}

prim_rw beta_reduction {| reduce |} :
   (lambda{x.'t['x]} 'a) <--> 't['a]

doc <:doc< 
   @begin[doc]
   @modsection{Sequents}
   The @tt[sequent_arg] term is used to mark CS101 sequents to emphasize
   that their semantics differs from other semantics for sequents (such as the ITT's one).
   @end[doc]
>>

declare sequent_arg

doc <:doc< @doc{@modsection{Structural rules}} >>

declare member{'t; 'T}

prim type_axiom 'H :
   sequent { <H>; x: 'A; <J> >- 'x in 'A } = it

let resource auto += [{
   auto_name = "cs101";
   auto_prec = trivial_prec;
   auto_tac = onSomeHypT type_axiom;
   auto_type = AutoTrivial;
}]

prim swap 'H 'J 'K :
   sequent { <H>; <K>; <J>; <L> >- 'C } -->
   sequent { <H>; <J>; <K>; <L> >- 'C } = it

prim cut 'C bind{x.'t1['x]} 't2 :
   sequent { <H> >- 't2 in 'C } -->
   sequent { <H>; x: 'C >- 't1['x] in 'T } -->
   sequent { <H> >- 't1['t2] in 'T } = it

open Tactic_boot.Tactic
open Tactic_type.Sequent
open Refiner.Refiner
open Refiner.Refiner.TermOp
open Var

let cutAssumT = argfunT (fun i p ->
   let assum = TermMan.nth_concl (nth_assum p i) 1 in
   let term, typ = two_subterms assum in
   let cterm, _ = two_subterms (concl p) in
   let bind = var_subst_to_bind cterm term in
      cut typ bind term thenLT [trivialT; idT] )

doc <:doc< @doc{@modsection{Constant Types}} >>

declare "void"
declare "unit"

prim void_elim {| elim [] |} 'H:
   sequent { <H>; x: "void"; <J> >- 'C['x] } = it

prim unit_type {| intro [] |} :
   sequent { <H> >- it in "unit" } = it

doc <:doc< @doc{@modsection{Function type}} >>

declare "fun"{'A; x.'B['x] }
define unfold_fun : "fun"{'A; 'B} <--> "fun"{'A; x.'B}

prim lambda_dep_type {| intro [] |} :
   sequent { <H>; x: 'A >- 't['x] in 'B['x] } -->
   sequent { <H> >- lambda{x.'t['x]} in (x:'A -> 'B['x]) } = it

interactive lambda_type {| intro [] |}:
   sequent { <H>; x: 'A >- 't['x] in 'B } -->
   sequent { <H> >- lambda{x.'t['x]} in ('A -> 'B) }

prim apply_dep_type {| intro [] |} (x:'B -> 'A['x]) :
   sequent { <H> >- 'a in (x:'B -> 'A['x]) } -->
   sequent { <H> >- 'b in 'B } -->
   sequent { <H> >- ('a 'b) in 'A['b] } = it

interactive apply_type {| intro [] |} 'B :
   sequent { <H> >- 'a in ('B -> 'A) } -->
   sequent { <H> >- 'b in 'B } -->
   sequent { <H> >- ('a 'b) in 'A }

interactive example1:
   sequent { >- (lambda{x.'x} lambda{y.'y}) in ('A -> 'A) }

interactive void_lambda :
   sequent { >- lambda{x.'t['x]} in ("void" -> 'A) }

interactive fun_elim 'H bind{x.'t1['x]} bind{x,y.'t2['x;'y]} :
  sequent { <H>; x: ('A -> 'B); <J> >- 't1['x] in 'A } -->
  sequent { <H>; x: ('A -> 'B); y: 'B; <J> >- 't2['x;'y] in 'C } -->
  sequent { <H>; x: ('A -> 'B); <J> >- 't2['x; 'x 't1['x]] in 'C }

doc <:doc< @doc{@modsection{Product type}} >>

declare pair{'a;'b}
declare fst{'a}
declare snd{'a}

prim_rw reduce_fst {| reduce |} :
   fst{('a,'b)} <--> 'a

prim_rw reduce_snd {| reduce |} :
   snd{('a,'b)} <--> 'b

declare prod{'A;x.'B['x]}
define unfold_prod : prod{'A;'B} <--> prod{'A;x.'B}

prim dep_pair_type {| intro [] |} :
   sequent { <H> >- 'a in 'A } -->
   sequent { <H> >- 'b in 'B['a] } -->
   sequent { <H> >- ('a,'b) in (x:'A * 'B['x]) } = it

interactive pair_type {| intro [] |} :
   sequent { <H> >- 'a in 'A } -->
   sequent { <H> >- 'b in 'B } -->
   sequent { <H> >- ('a,'b) in ('A * 'B) }


prim dep_prod_elim {| elim [] |} 'H :
   sequent { <H>; u: 'A; v: 'B['u]; <J> >- 't[('u,'v)] in 'C } -->
   sequent { <H>; p: (x:'A * 'B['x]); <J> >- 't['p] in 'C } = it

interactive pair_elim {| elim [] |} 'H :
   sequent { <H>; u: 'A; v: 'B; <J> >- 't[('u,'v)] in 'C } -->
   sequent { <H>; x: ('A * 'B); <J> >- 't['x] in 'C }

interactive fst_type {| intro [] |} 'B :
   sequent { <H> >- 'a in ('A * 'B) } -->
   sequent { <H> >- fst{'a} in 'A }

interactive snd_type {| intro [] |} 'A :
   sequent { <H> >- 'a in ('A * 'B) } -->
   sequent { <H> >- snd{'a} in 'B }

doc <:doc< @doc{@modsection{Disjoint union type}} >>

declare inl{'x}
declare inr{'x}
declare decide{'x; u.'t1['u]; v.'t2['v]}

prim_rw reduce_inl {| reduce |} :
   decide{inl{'x}; u.'t1['u]; v.'t2['v]} <--> 't1['x]

prim_rw reduce_inr {| reduce |} :
   decide{inr{'x}; u.'t1['u]; v.'t2['v]} <--> 't2['x]

declare union{'A;'B}

prim inl_type {| intro [] |} :
   sequent { <H> >- 'a in 'A } -->
   sequent { <H> >- inl{'a} in ('A + 'B) } = it

prim inr_type {| intro [] |} :
   sequent { <H> >- 'b in 'B } -->
   sequent { <H> >- inr{'b} in ('A + 'B) } = it

prim union_elim {| elim [] |} 'H :
  sequent { <H>; u: 'A; <J[inl{'u}]> >- 't[inl{'u}] in 'C[inl{'u}] } -->
  sequent { <H>; v: 'B; <J[inr{'v}]> >- 't[inr{'v}] in 'C[inr{'v}] } -->
  sequent { <H>; x: ('A + 'B); <J['x]> >- 't['x] in 'C['x] } = it

interactive decide_type {| intro [] |} ('A + 'B) :
   sequent { <H> >- 'x in ('A + 'B) } -->
   sequent { <H>; u: 'A >- 't1['u] in 'C } -->
   sequent { <H>; v: 'B >- 't2['v] in 'C } -->
   sequent { <H> >- decide{'x; u.'t1['u]; v.'t2['v]} in 'C }

interactive example2 :
   sequent { >- lambda{x.decide{'x; u.'u; v.'v}}
      in (x:('A + 'B) -> decide {'x;u. 'A; v. 'B}) }

doc docoff

(************************************************************
 * DISPLAY FORMS                                            *
 ************************************************************)
                                                
prec prec_fun
prec prec_apply                                  
prec prec_lambda
prec prec_prod                                   
prec prec_equal
prec prec_lambda < prec_apply                    
prec prec_fun < prec_apply
prec prec_fun < prec_lambda                      
prec prec_equal < prec_apply

dform void_df : "void" = `"Void"
dform unit_df : "unit" = `"Unit"

dform lambda_df : parens :: except_mode [src] :: "prec"[prec_lambda] :: lambda{x. 'b} =
      Nuprl_font!lambda slot{'x} `"." slot{'b}

dform apply_df : parens :: "prec"[prec_apply] ::
   apply{'f; 'a} = slot["lt"]{'f} " " slot["le"]{'a}

dform member_df : except_mode[src] :: parens :: "prec"[prec_equal] :: ('x in 'T) =
      szone pushm slot{'x} space Nuprl_font!member 
      hspace slot{'T} popm ezone

dform fun_df : parens :: "prec"[prec_fun] :: "fun"{'A; 'B} =
   slot["le"]{'A} " " rightarrow " " slot["lt"]{'B}

dform fun_df2 : parens :: "prec"[prec_fun] ::
   "fun"{'A; x. 'B} =
         slot{bvar{'x}} `":" slot{'A} " " rightarrow " " slot{'B}

dform it_df1 : except_mode[src] :: it = cdot

dform fst_df1 : except_mode[src] :: fst{'e} =
   slot{'e} `".1"

dform snd_df1 : except_mode[src] :: snd{'e} =
   slot{'e} `".2"

dform pair_prl_df : except_mode[src] :: pair{'a; 'b} =
   pushm[0] `"(" slot{'a}`"," slot{'b} `")" popm

dform prod_df : parens :: "prec"[prec_prod] :: prod{'A; 'B} =
   pushm[0] slot{'A} " " times " " slot{'B} popm

dform prod_df : parens :: "prec"[prec_prod] :: prod{'A; x.'B} =
   pushm[0] slot{bvar{'x}} `":" slot{'A}
         " " times " " slot{'B} popm

prec prec_inl
prec prec_union

dform union_df : except_mode[src] :: parens :: "prec"[prec_union] :: \union{'A; 'B} =
      slot{'A} " " `"+" " " slot{'B}

dform inl_df : except_mode[src] :: parens :: "prec"[prec_inl] :: inl{'a} =
    `"inl" " " slot{'a}

dform inr_df : except_mode[src] :: parens :: "prec"[prec_inl] :: inr{'a} =
    `"inr" " " slot{'a}

dform decide_df : except_mode[src] :: decide{'x; y. 'a; z. 'b} =
   szone pushm[0] pushm[3] `"match" " " slot{'x} " "
   `"with" hspace szone `"inl " slot{'y} `" " rightarrow hspace slot{'a} ezone popm hspace
   pushm[3] szone `"| inr " slot{'z} `" " rightarrow hspace slot{'b} ezone popm popm ezone

dform seq_df1 : mode[prl] :: sequent_arg =
   subone subzero subone

dform seq_df2 : except_mode[prl] :: sequent_arg = sub["101"]
