doc <:doc<
   @spelling{CS101}
   @begin[doc]
   @module{CS101 Intuitionistic Logic Theory}
   @parents
   The CS101 formalization of intuitionistic logic is grounded
   in the Base theory, that defines basic concepts and basic
   proof search automation.
   @end[doc]
>>

extends Base_theory
extends Cs101_lc

doc <:doc< 
   @begin[doc]
   @terms
   The following declarations define the language of the logic.
   @end[doc]
>>

define unfold_true : "true" <--> "unit"
define unfold_false : "false" <--> "void"
define unfold_or : "or"{'A;'B} <--> 'A + 'B
define unfold_and : "and"{'A;'B} <--> 'A * 'B
define unfold_implies : "implies"{'A;'B} <--> 'A -> 'B
define unfold_not: "not"{'A} <--> 'A => "false"

(************************************************************************
 * RULES OF THE INTUITIONISTIC LOGIC                                    *
 ************************************************************************)

open Top_tacticals
open Dtactic
open Auto_tactic

doc <:doc<
   @begin[doc]
   @rules
   The rules below are exactly the same that were presented and discussed
   in the first week of the class.
   @end[doc]
>>

prim useWitness 't :
   sequent { <H> >- 't in 'T } -->
   sequent { <H> >- 'T } = 't

prim cutWitness 'A :
   ('a : sequent { <H> >- 'A }) -->
   ( 'c['x] : sequent { <H>; x: 'A >- 'C }) --> 
   sequent { <H> >- 'C } = 'c['a]

interactive swap 'H 'J 'K :
   sequent { <H>; <K>; <J>; <L> >- 'C } -->
   sequent { <H>; <J>; <K>; <L> >- 'C }

interactive axiom 'H :
   sequent { <H>; 'A; <J> >- 'A }

let resource auto += [{
   auto_name = "cs101";
   auto_prec = trivial_prec;
   auto_tac = onSomeHypT axiom;
   auto_type = AutoTrivial;
}]

interactive copy 'H : 
   sequent { <H>; 'A; 'A; <J> >- 'C } -->
   sequent { <H>; 'A; <J> >- 'C }

prim thin 'H :
   ('t : sequent { <H>; <J> >- 'C }) -->
   sequent { <H>; 'A; <J> >- 'C } = 't

interactive true_i {| intro [] |} :
   sequent { <H> >- "true" }

interactive false_e {| elim [] |} 'H :
   sequent { <H>; "false"; <J> >- 'C }

let resource auto += [{
   auto_name = "cs101";
   auto_prec = trivial_prec;
   auto_tac = onSomeHypT false_e;
   auto_type = AutoTrivial;
}]

prim imp_i {| intro [] |}:
   ('t['x] : sequent { <H>; x: 'A >- 'B }) -->
   sequent { <H> >- 'A => 'B } = lambda{x.'t['x]}

interactive imp_e {| elim [] |} 'H :
   sequent { <H>; <J> >- 'A } -->
   sequent { <H>; 'B; <J> >- 'C } -->
   sequent { <H>; 'A => 'B; <J> >- 'C }

interactive or_i1 {| intro [SelectOption 1] |} :
   sequent { <H> >- 'A } -->
   sequent { <H> >- 'A or 'B }
      
interactive or_i2 {| intro [SelectOption 2] |} :
   sequent { <H> >- 'B } -->
   sequent { <H> >- 'A or 'B }

interactive or_e {| elim [] |} 'H :
   sequent { <H>; 'A; <J> >- 'C } -->
   sequent { <H>; 'B; <J> >- 'C } -->
   sequent { <H>; 'A or 'B; <J> >- 'C }

interactive and_i {| intro [] |} :
   sequent { <H> >- 'A } -->
   sequent { <H> >- 'B } -->
   sequent { <H> >- 'A and 'B }

interactive and_e {| elim [] |} 'H :
   sequent { <H>; 'A; 'B; <J> >- 'C } -->
   sequent { <H>; 'A and 'B; <J> >- 'C }

interactive not_i {| intro [] |} :
   sequent { <H>; 'A >- "false" } -->
   sequent { <H> >- "not"{'A} }

interactive not_e {| elim [] |} 'H :
   sequent { <H>; <J> >- 'A } -->
   sequent { <H>; "not"{'A}; <J> >- 'C }

doc <:doc< @docoff >>

(************************************************************************
 * DISPLAY FORMS							*
 ************************************************************************)

prec prec_iff
prec prec_implies
prec prec_and
prec prec_or
prec prec_not
prec prec_quant

prec prec_implies < prec_iff
prec prec_iff < prec_or
prec prec_or < prec_and
prec prec_and < prec_not
prec prec_quant < prec_iff

dform true_df : except_mode[src] :: "true" =
   `"True"

dform false_df : except_mode[src] :: "false" =
   `"False"

dform not_df1 : except_mode[src] :: parens :: "prec"[prec_not] :: "not"{'a} =
   Nuprl_font!tneg slot["le"]{'a}

dform not_df2 : mode[src] :: parens :: "prec"[prec_implies] :: "not"{'a} =
   `"not " slot["le"]{'a}

(*
 * Implication.
 *)
declare implies_df{'a}

dform implies_df1 : parens :: "prec"[prec_implies] :: "implies"{'a; 'b} =
   szone pushm[0] slot["le"]{'a} implies_df{'b} popm ezone

dform implies_df2 : implies_df{."implies"{'a; 'b}} =
   implies_df{'a} implies_df{'b}

dform implies_df3 : implies_df{'a} =
   hspace Nuprl_font!Rightarrow " " slot{'a}

(*
 * Disjunction.
 *)
declare or_df{'a}

dform or_df1 : parens :: "prec"[prec_or] :: "or"{'a; 'b} =
   szone pushm[0] slot["le"]{'a} or_df{'b} popm ezone

dform or_df2 : or_df{."or"{'a; 'b}} =
   or_df{'a} or_df{'b}

dform or_df3 : or_df{'a} =
   hspace Nuprl_font!vee " " slot{'a}

(*
 * Conjunction.
 *)
declare and_df{'a}

dform and_df1 : parens :: "prec"[prec_and] :: "and"{'a; 'b} =
   szone pushm[0] slot["le"]{'a} and_df{'b} popm ezone

dform and_df2 : and_df{."and"{'a; 'b}} =
   and_df{'a} and_df{'b}

dform and_df3 : and_df{'a} =
   hspace Nuprl_font!wedge " " slot{'a}

dform it_df1 : except_mode[src] :: it = cdot
