(**************************************************************
 *         CS101: Homework 4 --- Types                        *
 **************************************************************)

(*
 * Introduce a type alias to make it more obvious which strings are meant
 * to be interpreted as variable names
 *)
type var = string

(*
 * Security lattice
 *)
module type LatticeSig = sig
   type t
   val less_or_eq : t -> t -> bool
   val join : t -> t -> t
end

module MakeTypes (Lattice: LatticeSig) = struct

   type sec = Lattice.t      (* abbreviation for lattice values *)
   type sec_prop = sec * sec (* security properties:  K := (r, ir) *)
   
   (*
    * SLam types:
    *   t := unit
    *     |  t -> t
    *     |  t + t
    *)
   type slam_pre_type =
      TyUnit
    | TyFun of slam_type * slam_type
    | TyUnion of slam_type * slam_type

   (* s := (t, k) *)
   and slam_type = slam_pre_type * sec_prop
   
   (*
    * SLam expressions:
    *   e := ()  (k)
    *     |  x
    *     |  inj1 e (k) | inj2 e (k)
    *     |  case e of inj1(x) -> e | inj2(x) -> e  (r)
    *     |  e e (r)
    *     |  lambda x: s. e (k)
    * 
    * We use a somewhat unusual representation for inj:
    *   - false is "inj1" and true is "inj2"
    *   - we include the type of the "other" branch : 
    *     ExpInj(true, e, k, t1) has type ((t1+t2), k) when e has type t2.
    *)
   type slam_exp =
      ExpUnit of sec_prop
    | ExpVar of var
    | ExpInj of bool * slam_exp * sec_prop * slam_type
    | ExpCase of slam_exp * var * slam_exp * var * slam_exp * sec
    | ExpApply of slam_exp * slam_exp * sec
    | ExpLambda of var * slam_type * slam_exp * sec_prop
   
   (*
    * Type errors:
    *   - "Expression e has type t1, but is used with type t2"
    *   - "Expression e of non-functional type t is used in a function position"
    *   - "Variable v is not bound"
    *   - "In expression e, security context r (or ir) tried to make an operation allowed only for r' (or ir')"
    *)
   type slam_error =
         ErrTypeMismatch of slam_exp * slam_type * slam_type
      |  ErrTypeFunApp of slam_exp * slam_type
      |  ErrUnknownVariable of var
      |  ErrSecurityViolation of slam_exp * sec * sec
   
   exception SlamError of slam_error
   exception InternalError of string
end
