(**************************************************************
 *  CS101: Homework 4 --- Type checker and interpreter        *
 **************************************************************)

open Cs101_hw4_p1_types

module VarMap = Map.Make(String)

(*
 * SLam type checker.
 *)
module SLamTC (Lattice: LatticeSig) = struct
   module Types = MakeTypes(Lattice)
   open Types

   type type_environment = slam_type VarMap.t

   (*
    * SLam type inference.
    * Raises SlamError if the input is not well-typed.
    *)
   let rec slam_get_type (gamma : type_environment) e =
      match e with
         _ -> raise (Invalid_argument "slam_get_type: not implemented")

   (*
    * SLam type checker.
    * Raises SlamError if the input is not well-typed.
    *)
   let slam_type_check =
      slam_get_type VarMap.empty
end
